require "EatLists"

return Class(function(self, inst)
	self.inst = inst
	
	self.update = false
	
	self.table =
	{
		allFood = {},
		tarFood = {},
		checker = {},
		randomNum = 0,
		dayCount = 0,
		limit = 40,
		yearMode = false,
		seasonMode = false,
		cycleMode = true,
		currentSeason = GetSeasonManager():GetSeason(),
	}
	
	self.options = 
	{
		yearMode = false,
		seasonMode = false,
		cycleMode = true,
		SW = 1,
		RoG = 1,
		Vanilla = 0,
		crockpot = false,
		crockpot10 = false,
		crockpot20 = true,
		rand10 = false,
		rand20 = false,
		rand30 = false,
		rand40 = false,
		easy = 1,
		longterm = 1,
		rare = 1,
		caves = 1,
	}

local function CanEatTest(inst, item)
	local tempFood = self.table.allFood
	local canEat = tempFood[item.prefab]
    return canEat
end

if picky_eater then
	GetPlayer().components.eater:SetCanEatTestFn(CanEatTest)
end

local function checkList()
	local checker = 0
	for k,v in pairs(self.table.checker) do
		if v == false then
			checker = checker + 1
		end
	end
	
	if checker == 0 then
		self:reset()
		self.update = true
	end		
end

local function shuffle(array)
	local seed = (string.sub(os.time(),-5))
	math.randomseed(seed)
	local arrayCount = #array
	for f = arrayCount, 1, -1 do
		math.random(os.time())
        	local j = math.random(f)
        	array[f], array[j] = array[j], array[f]
    	end
   return array
end

function self:reset()

	local tempFoodList = {}
	self.table.allFood = {}
	self.table.tarFood = {}
	self.table.checker = {}
	for k,v in pairs(allFood) do
		self.table.allFood[k] = v
	end
	self.table.dayCount = 0
	self.table.limit = 40
	
	self.table.yearMode = self.options.yearMode
	self.table.seasonMode = self.options.seasonMode
	self.table.cycleMode = self.options.cycleMode	
	
	if GetPlayer().prefab == "wx78" then
		self.table.allFood["gears"] = true
	end
	
	if self.options.crockpot or self.options.crockpot10 or self.options.crockpot20 then
		if GetPlayer().prefab == "wathgrithr" then
			if self.options.Vanilla %2 == 0  then
				for k,v in pairs(wigfridCrockpot) do
					table.insert(tempFoodList,v)
				end	
				if self.options.easy %2 == 0 and self.options.caves %2 == 0 then
					for k,v in pairs(wigfridCrockpotCave) do
						table.insert(tempFoodList,v)
					end	
				end
				if self.options.RoG %2 == 0 then
					for k,v in pairs(wigfridCrockpotRoG) do
						table.insert(tempFoodList,v)
					end	
				end
			end
			if self.options.SW %2 == 0  then
				for k,v in pairs(srWigPot) do
					table.insert(tempFoodList,v)
				end			
			end
		else
			if self.options.Vanilla %2 == 0 then
				for k,v in pairs(crockpotFood) do
					table.insert(tempFoodList,v)
				end			
				if self.options.caves %2 == 0 then
					for k,v in pairs(crockpotCave) do
						table.insert(tempFoodList,v)
					end		
				end
				if self.options.rare %2 == 0 then
					for k,v in pairs(crockpotRare) do
						table.insert(tempFoodList,v)
					end	
				end
				if self.options.longterm %2 == 0 then
					for k,v in pairs(crockpotLongterm) do
						table.insert(tempFoodList,v)
					end	
				end
			end
			if self.options.RoG %2 == 0 then
				for k,v in pairs(rogCrockpot) do
					table.insert(tempFoodList,v)
				end	
				if self.options.longterm %2 == 0 then
					for k,v in pairs(rogLongtermPot) do
						table.insert(tempFoodList,v)
					end	
				end			
			end
			if self.options.SW %2 == 0 then
				for k,v in pairs(srPot) do
					table.insert(tempFoodList,v)
				end	
				if self.options.easy %2 == 0 then
					for k,v in pairs(srPotHard) do
						table.insert(tempFoodList,v)
					end	
				end	
				if self.options.longterm %2 == 0 then
					for k,v in pairs(srPotLongterm) do
						table.insert(tempFoodList,v)
					end	
				end					
			end
			if GetPlayer().prefab == "warly" then
				for k,v in pairs(srWarly) do
					table.insert(tempFoodList,v)
				end
			end
		end	
	else
		if GetPlayer().prefab == "wathgrithr" then
			if self.options.Vanilla %2 == 0  then
					for k,v in pairs(wigfridFood) do
						table.insert(tempFoodList,v)
					end
				if self.options.longterm %2 == 0 then
					for k,v in pairs(wigfridLongterm) do
						table.insert(tempFoodList,v)
					end
				end
				if self.options.caves %2 == 0 then
					for k,v in pairs(wigfridCave) do
						table.insert(tempFoodList,v)
					end
				end
				for k,v in pairs(wigfridCrockpot) do
					table.insert(tempFoodList,v)
				end	
				if self.options.longterm %2 == 0 and self.options.easy %2 == 0 then
					table.insert(tempFoodList,"deerclops_eyeball")
				end
			end
			if self.options.RoG %2 == 0 then
				for k,v in pairs(wigfridCrockpotRoG) do
					table.insert(tempFoodList,v)
				end	
			end
			if self.options.easy %2 == 0 and self.options.caves %2 == 0 then
				for k,v in pairs(wigfridCrockpotCave) do
					table.insert(tempFoodList,v)
				end	
				table.insert(tempFoodList,"minotaurhorn")
			end						
			if self.options.SW %2 == 0  then
				for k,v in pairs(srWig) do
					table.insert(tempFoodList,v)
				end
				for k,v in pairs(srWigPot) do
					table.insert(tempFoodList,v)
				end	
				if self.options.easy %2 == 0 then
					for k,v in pairs(srWigHard) do
						table.insert(tempFoodList,v)
					end
				end
				if self.options.longterm %2 == 0 then
					for k,v in pairs(srWigLongterm) do
						table.insert(tempFoodList,v)
					end
				end
			end
		else
			if self.options.Vanilla %2 == 0  then
				for k,v in pairs(allFoods) do
					table.insert(tempFoodList,v)
				end
				if self.options.easy %2 == 0 then
					for k,v in pairs(allFoodsHard) do
						table.insert(tempFoodList,v)
					end
				end
				if self.options.caves %2 == 0 then
					for k,v in pairs(allFoodsCave) do
						table.insert(tempFoodList,v)
					end
				end
				if self.options.caves %2 == 0 and self.options.easy %2 == 0 then
					table.insert(tempFoodList,"minotaurhorn")
				end
				if self.options.longterm %2 == 0 then
					for k,v in pairs(allFoodsLongterm) do
						table.insert(tempFoodList,v)
					end
				end
				if self.options.longterm %2 == 0 and self.options.easy %2 == 0 then
					table.insert(tempFoodList,"deerclops_eyeball")
				end
				if self.options.rare %2 == 0 then
					for k,v in pairs(allFoodsRare) do
						table.insert(tempFoodList,v)
					end
				end			
			end
			if self.options.RoG %2 == 0  then
				for k,v in pairs(rogAll) do
					table.insert(tempFoodList,v)
				end
				if self.options.longterm %2 == 0 then
					for k,v in pairs(rogLongterm) do
						table.insert(tempFoodList,v)
					end
				end	
			end
			if self.options.SW %2 == 0  then
				for k,v in pairs(srAll) do
					table.insert(tempFoodList,v)
				end
				if self.options.longterm %2 == 0 then
					for k,v in pairs(srLongterm) do
						table.insert(tempFoodList,v)
					end
				end
				if self.options.easy %2 == 0 then
					for k,v in pairs(srHard) do
						table.insert(tempFoodList,v)
					end
				end	
			end		
			if GetPlayer().prefab == "warly" then
				for k,v in pairs(srWarly) do
					table.insert(tempFoodList,v)
				end
			end	
		end	
	end
	
	shuffle(tempFoodList)	
	if self.options.crockpot10 or self.options.rand10 then
		self.table.limit = 10	
	elseif self.options.rand20 or (self.options.crockpot20 and GetPlayer().prefab ~= "wathgrithr") then
		self.table.limit = 20	
	elseif self.options.rand30 and GetPlayer().prefab ~= "wathgrithr" then
		self.table.limit = 30	
	elseif self.options.rand40 and GetPlayer().prefab ~= "wathgrithr" then
		self.table.limit = 40	
	else
		self.table.limit = #tempFoodList
		if self.table.limit > 40 then
			self.table.limit = 40
		end
	end
	
	for k,v in ipairs(tempFoodList) do
		if self.table.limit >= k then 
			table.insert(self.table.tarFood,v)
			self.table.checker[k] = false
		end
	end
	
	for k,v in pairs(self.table.tarFood) do	
		self.table.allFood[v] = true
	end
end

function self:OnSave()   	
	local data =	
	{
		_table = self.table,
		_options = self.options,
	}
	return data
end

function self:OnLoad(data) 
	if data and data._options and data._options ~= nil then
		self.options = data._options 
	end
	if data and data._table and data._table ~= nil then
		self.table = data._table 
	end
end

local function OnEat(inst, data)
	if data.food.prefab == "gears" then
		return
	end
	if self.table.allFood[data.food.prefab] == true then
		self.table.allFood[data.food.prefab] = false
		for k,v in pairs(self.table.tarFood) do
			if v == data.food.prefab then
				self.table.checker[k] = true
			end
		end
		self.update = true
		if self.table.cycleMode then
			checkList()
		end
	end
end

self.inst:ListenForEvent("seasonChange", function() 
	if self.table.seasonMode then
		local season = GetSeasonManager():GetSeason()
		if self.table.currentSeason ~= season then
			self.table.currentSeason = season
			self:reset() 
			self.update = true 
		end
	end
end, GetWorld())
self.inst:ListenForEvent( "daycomplete", function()
	if self.table.yearMode then
		self.table.dayCount = self.table.dayCount + 1
		if self.table.dayCount > year_length then
			self:reset()
			self.update = true
		end
	end
end, GetWorld())
self.inst:ListenForEvent("oneat", OnEat)
self.inst:StartUpdatingComponent(self)
end)